/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.kyrptonaught.kyrptconfig.config.AbstractConfigFile;
import net.kyrptonaught.kyrptconfig.config.ConfigWDefaults;

public class ConfigStorage {
    private final Path saveFile;
    public AbstractConfigFile config;
    private final AbstractConfigFile defaultConfig;

    public ConfigStorage(Path fileName, AbstractConfigFile defaultConfig) {
        this.saveFile = fileName;
        this.defaultConfig = defaultConfig;
    }

    public void save(String MOD_ID, Jankson JANKSON) {
        try (OutputStreamWriter out = new OutputStreamWriter(Files.newOutputStream(this.saveFile, new OpenOption[0]), StandardCharsets.UTF_8);){
            if (this.config instanceof ConfigWDefaults) {
                ((ConfigWDefaults)this.config).beforeSave();
            }
            String json = JANKSON.toJson((Object)this.config).toJson(true, true);
            out.write(json);
        }
        catch (Exception e) {
            System.out.println(MOD_ID + " Failed to save " + this.saveFile.getFileName().toString());
        }
    }

    public AbstractConfigFile load(String MOD_ID, Jankson JANKSON) {
        if (!Files.exists(this.saveFile, new LinkOption[0]) || !Files.isReadable(this.saveFile)) {
            System.out.println(MOD_ID + " Config not found! Creating one.");
            this.config = this.defaultConfig;
        }
        boolean failed = false;
        try {
            JsonObject configJson = JANKSON.load(Files.newInputStream(this.saveFile, StandardOpenOption.READ));
            String regularized = configJson.toJson(false, false, 0);
            this.config = (AbstractConfigFile)JANKSON.fromJson(regularized, this.defaultConfig.getClass());
            if (this.config instanceof ConfigWDefaults) {
                ((ConfigWDefaults)this.config).DEFAULTS = this.defaultConfig;
                ((ConfigWDefaults)this.config).afterLoad();
            }
        }
        catch (Exception e) {
            failed = true;
        }
        if (failed || this.config == null) {
            System.out.println(MOD_ID + " Failed to load config! Overwriting with default config.");
            this.config = this.defaultConfig;
        }
        return this.config;
    }
}

